package jadean.dean.java.resources;


import jadean.dean.Resource;
import jadean.dean.exceptions.ResourceIOException;
import jadean.dean.exceptions.ResourceInvalidException;
import jadean.dean.exceptions.ResourceNotFoundException;
import jadean.dean.java.JavaPackage;
import jadean.dean.java.JavaProject;
import jadean.dean.java.JavaResource;
import jadean.dean.java.resourceparser.classparser.ClassResourceParser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class JavaResourceReferencedClass extends JavaResourceProjectResource {

	public JavaResourceReferencedClass(String name, JavaResourceContext context, JavaProject p) {
		super(name, context, p);
	}

	@Override
	public Collection<Resource> getReferrencedResources() {
		try {
			JavaPackage pa = this.getPackageForResource();
			ClassResourceParser crp;
			try {
				crp = new ClassResourceParser(this.getName(), pa.getInputStreamForClass(this.getName()));
			}
			catch (IOException e) {
				throw new ResourceNotFoundException();
			}
			Collection<Resource> s = crp.getReferencedResources();
			ArrayList<Resource> ret = new ArrayList<Resource>();
			JavaResourceFactory rf = new JavaResourceFactory(this.getProject());
			for (Resource resource: s) {
				JavaResource javaResource = (JavaResource) resource;
				ret.add(rf.classNameToResource(javaResource.getName(), javaResource.getContext()));
			}
			if (crp.isReflectionUsed()) {
				getProject().setReflectionUsed(true);
			}
			return ret;
		}
		catch (ResourceNotFoundException e) {
			return new ArrayList<Resource>();
		}
		catch (ResourceIOException e) {
			e.printStackTrace();
			return new ArrayList<Resource>();
		}
		catch (ResourceInvalidException e) {
			return new ArrayList<Resource>();
		}
	}

	@Override
	public JavaPackage getPackageForResource() {
		for (JavaPackage _p: this.getProject().getClassesInReferencedLibraries().keySet()) {
			for (String s: this.getProject().getClassesInReferencedLibraries().get(_p)) {
				if (s.equals(this.getName()) || s.startsWith(this.getName())) {
					return _p;
				}
			}
		}
		return null;
	}

	@Override
	public void delete() {
		
	}

}
